<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\LabTest;

class LabTestSeeder extends Seeder
{
    public function run()
    {
        $labTests = [
            [
                'name' => 'تحاليل الفحص الشامل',
                'description' => 'وتشمل مجموعة من التحاليل الطبية يتم عملها دوريا (كل ستة أشهر) وهي كما يلي: - وظائف الكبد SGOT, SGPT - وظائف الكلى Urea, Creatinine - صورة دم CBC - سكر صائم FBS - سرعة ترسيب ESR - أملاح النقرس Uric Acid - تحليل بول Urine Analysis - دهنيات الدم كاملة Lipid profile',
            ],
            [
                'name' => 'تحاليل مرض السكر',
                'description' => '- سكر صائم FBS - سكر بعد الأكل 2hrPP - الهيموجلوبين السكري HBA1C - منحنى السكر Glucose curve - الميكروألبومينوريا Microalbuminuria',
            ],
            [
                'name' => 'دهنيات الدم',
                'description' => 'كوليستيرول + الدهون الثلاثية + كوليستيرول منخفض الكثافة + كوليستيرول مرتفع الكثافة Total Cholesterol + Triglycerides + HDL + LDL',
            ],
            [
                'name' => 'تحاليل وظائف الكبد',
                'description' => 'Bilirubin (Total + Direct) + ALT (SGPT) + AST (SGOT) + PT + Albumin + GGT + Total Protein + Alkaline Phosphatase',
            ],
            [
                'name' => 'تحاليل وظائف الكلى',
                'description' => 'Creatinine + Urea + Uric acid + Urine analysis + Sodium and Potassium',
            ],
            [
                'name' => 'تحاليل سيولة الدم',
                'description' => '- سرعة النزف Bleeding time (BT) - سرعة التجلط Clotting time (CT) - سيولة الدم Prothrombin time (PT) - تخثر الدم Partial Thromboplastin Time (PTT) - عدد الصفائح Platelets count - مستوى الفيبرينوجين Fibrinogen Level - مستوى Fibrinogen Degradation Products',
            ],
            [
                'name' => 'أمراض الدم',
                'description' => '- صورة الدم Complete Blood Count (CBC) - الخلايا الشبكية Retix count - الفصل الكهربائي للهيموجلوبين Hb Electrophoresis - كومب مباشر Direct Coomb\'s - كومب غير مباشر Indirect Coomb\'s (or Rh Antibodies) - فصيلة الدم Blood Group & Rh - أنيميا الفول Glucose 6 phosphate dehydrogenase (G6PD)',
            ],
            [
                'name' => 'الهرمونات',
                'description' => '- هرمونات العقم للسيدات: Estrogen + Progesterone + FSH + LH + Prolactin + Testosterone (Total & Free) - هرمونات العقم للرجال: Testosterone (Total & Free) + LH + FSH + Prolactin + Estrogen - هرمونات الغدة الدرقية: T3 + T4 + TSH + Free T3 + Free T4 - هرمونات الغدة الجار درقية: Parathyroid Hormone (PTH) - هرمونات الغدة فوق الكلوية: Cortisol (AM & PM) + ACTH (AM & PM) + Adrenaline + Noradrenaline + Dopamine + Renin - هرمونات مختلفة ومتنوعة: Growth hormone (GH) + B-HCG + DHEA-S + 17 hydroxyprogesterone',
            ],
            [
                'name' => 'تحاليل التورش للسيدات (TORCH IGg & Igm)',
                'description' => 'Toxoplasma + Rubella + Cytomegalo Virus + Herpes I & II',
            ],
            [
                'name' => 'تحاليل الباثولوجي',
                'description' => '- عينات مأخوذة من أنسجة بالجسم وتحتاج إلى فحصها للتأكد من عدم وجود أورام بها (Biopsy) - سوائل مسحوبة من الجسم وتحتاج إلى فحصها للتأكد من عدم وجود أورام بها (Cytology) - شرائح مرسلة للفحص من عنق الرحم (PAP smear) - شرائح مرسلة وقد تم فحصها سابقًا من طبيب آخر ومطلوب رأي المعمل فيها (Consultation) - شرائح مرسلة غير مصبوغة أو بلوكات شمع ومطلوب صبغات مناعية لخلايا الأورام (Immunohistochemistry)',
            ],
            [
                'name' => 'قياس الأدوية العلاجية',
                'description' => '- أدوية الصرع: Tegretol (valproic acid) + Depakine (carbamazepine) + Epanutin (phenytoin) - أدوية القلب: Digoxin (lanoxin) - أدوية نفسية: Lithium',
            ],
            [
                'name' => 'تحاليل الوراثة',
                'description' => '- كروموزومات الدم Blood Chromosomes - كروموزومات الأنسجة Tissue Karyotyping - أحماض أمينية بالدم Aminogram in plasma - أحماض أمينية بالبول Aminogram in urine - فيلادلفيا كروموسوم Philadelphia chromosome',
            ],
            [
                'name' => 'المزارع',
                'description' => '- مزرعة بول Urine Exam C/S - مزرعة براز Stool Exam C/S - مزرعة وحساسية بروستاتا Prostatic Exam C/S - مزرعة من القضيب Urethral discharge C/S - مزرعة من المهبل Vaginal Exam C/S - مزرعة من العين Conjunctival C/S - مزرعة من الأذن Ear C/S - مزرعة من الحنجرة Throat swab C/S - مزرعة بصاق Sputum C/S - مزرعة من الأنف Nose C/S - مزرعة سائل منوي Semen Exam C/S - مزرعة من سائل النخاع CSF Exam C/S - مزرعة من جرح (صديد) Pus Exam C/S',
            ],
            [
                'name' => 'تحاليل الأمراض التي تنتقل جنسيا',
                'description' => '- الزهري (Syphilis) RPR + VDRL - الإيدز (HIV) HIV Ab - الكلاميديا Chlamydia Ab in blood or chlamydia Ag in urine - فيروس الهربس Herpes Simplex Virus (HSV) type I & II - الكبد الوبائي (ب) HBs Ag',
            ],
            [
                'name' => 'تحاليل مرض الدرن',
                'description' => '- فيلم (شريحة) لفحص الميكروب Film for AFB - صباغة فيلم بصبغة زيل نيلسون Film for ZN stain - مزرعة لميكروب الدرن Culture for TB - عمل تحليل بيولوجيا ج'
            ],
            [
                'name' => 'تحاليل الأمراض المناعية',
                'description' => '- الأجسام المضادة لنواة الخلية Anti Nuclear Ab (ANA) - الأجسام المضادة للعضلات الدقيقة Anti Smooth Muscles Ab (ASMA) - الأجسام المضادة للميتوكوندريا Anti Mitochondrial Ab (AMA) - الأجسام المضادة للـ DNA Anti DNA - الأجسام المضادة لليفر والكلى والميكروسوم Anti LKM - الأجسام المضادة للنواة والسيتوبلازم (أنكا) ANCA - الأجسام المضادة للصفائح الدموية Anti Platelet Ab - الأجسام المضادة للحيوانات المنوية في الدم أو السائل المنوي Anti Sperm Ab - مكمل C3 Complement 3 - مكمل C4 Complement 4'
            ],
            [
                'name' => 'تحاليل الحساسية',
                'description' => 'للأكل والمواد المستنشقة عن طريق الدم: Rast Specific IgE: Inhalant, Food or Pediatric'
            ],
            [
                'name' => 'تحاليل دلالات الاورام من الدم',
                'description' => 'دالات الثدى *CA15.3 *CEA *MCA
                                    دالات الرحم والمبيض *CA125 *CEA * B-HCG
                                    دالات الغدة الدرقية *Calcitonin * TBG (thyroid binding globulin) *NSE
                                    دالات الغدة الصنوبرية *ACTH *TSH * Prolactin *GH (Pituitary)
                                    دالات الكبد *AFP *CEA (Liver)
                                    دالات الكلى *Renin *B-HCG (Kidney)
                                    دالات اورام الخصية *B-HCG *Erythropoitein (Testis)
                                    دالات بروستاتا *PSA *Free PSA *Prostatic Acid Phosphatase (PAP) (Prostate)
                                    دالات الجهاز الهضمى *AFP *CA 19.9 *CEA
                                    دالات الرئه *CEA *CA 19.9 *NSE
                                    دالات المثانة *CEA *CA50'
            ],
            [
                'name' => 'اكتشاف الطفل المنجولي قبل الولادة',
                'description' => 'هناك تحليلين يتم عمل أحدهما لاكتشاف فرص وجود المرض (خلل في الكروموسومات):
                                1- PAPP – A (1st trimestric screening):
                                ويتم عمل تحليلين ثم يتم ادخال نتائجهم على برنامج كومبيوتر خاص موجود بالمعمل لحساب فرص حدوث المرض
                                1- PAPP – A 2- B-HCG
                                ويتم عمل هذا التحليل ما بين الاسبوع التاسع والرابع عشر من الحمل

                                2- Triple markers for Down Syndrome
                                ويتم عمل ثلاثة تحاليل ثم يتم ادخال نتائجهم على برنامج كومبيوتر خاص موجود بالمعمل لحساب فرص حدوث المرض
                                1- Alpha fetoprotein 2- B-HCG 3- Esteriol (E3)
                                ويتم عمل هذا التحليل ما بين الأسبوع الخامس عشر والأسبوع العشرين من الحمل وفى كلا التحليلين يتم أخذ معلومات عن الأم وهى:
                                1- أول يوم فى آخر دورة 2- الوزن 3- تاريخ الميلاد 4- يوجد سكر أم لا'
            ],
            [
                'name' => 'تحاليل الايدز',
                'description' => 'الاجسام المضادة للفيروس HIV Antibodies
                                ابحث عن الفيروس نفسه HIV by PCR'
            ],
            [
                'name' => 'تحاليل ما قبل الزواج',
                'description' => '. تحاليل الرجل Semen examination *Hb Electrophoresis * Blood Group & RH *Chromosomal Analysis *Fasting blood sugar
                                . تحاليل السيدة *Toxoplasma (IgG & IgM) * Hb Electrophoresis * Blood group & Rh * Fasting blood sugar * Chromosomal Analysis'
            ],
            [
                'name' => 'Risk Evaluation Profile',
                'description' => '- دهنيات الدم Lipid Profile
                                - مستوي الهوموسيستيين Homocystiene
                                - مستوي عامل التجلط 12 النشط Activated factor XII
                                - مستوي الفيبرينوجين Fibrinogen level
                                - مستوي High Sensitive CRP'
            ],
            [
                'name' => 'اكتشاف فرص تكون الجلطات بالدم Thrombotic Risk Profile',
                'description' => '- عدد الصفائح الدموية Platelet Count
                                - زمن وتركيز البروثرومبين PT
                                - عامل التجلط الخامس باستخدام الـ PCR Factor V by PCR
                                - زمن الثرومبوبلاستين PTT
                                - زمن الثرومبين Thrombin Time
                                - انتي ثرومبين 3 Anti Thrombin III
                                Protein C-
                                Protein S-
                                - مستوى FDPs
                                -مستوي الفيبرينوجين Fibrinogen leve
                                - مستوى Lupus Anticoagulant
                                - مستوى Anti Cardiolipin Abs. (IgG & IgM)'
            ]
        ];

        foreach ($labTests as $test) {
            LabTest::create($test);
        }
    }
}
