<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('pages')) {
            Schema::create('pages', function (Blueprint $table) {
                $table->id();
                $table->string('title');
                $table->string('slug')->unique();
                $table->text('content')->nullable();
                $table->enum('status', ['draft', 'published', 'scheduled'])->default('draft');
                $table->string('meta_title')->nullable();
                $table->string('meta_description')->nullable();
                $table->unsignedBigInteger('featured_image')->nullable(); // Add featured_image (store the ID from the media library)
                $table->foreignId('parent_id')->nullable()->constrained('pages')->onDelete('cascade'); // Parent page for hierarchy
                $table->timestamp('publish_at')->nullable(); // Publish date
                $table->foreignId('created_by')->constrained('users')->onDelete('cascade'); // User who created the page
                $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('cascade'); // User who updated the page
                $table->softDeletes(); // Soft delete
                $table->timestamps(); // Includes created_at, updated_at

                // Foreign key constraint to media table
                $table->foreign('featured_image')->references('id')->on('media')->onDelete('set null');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pages', function (Blueprint $table) {
            $table->dropForeign(['featured_image']);
            $table->dropColumn('featured_image');
        });

        Schema::dropIfExists('pages');
    }
};