<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if the table already exists
        if (!Schema::hasTable('settings')) {
            Schema::create('settings', function (Blueprint $table) {
                $table->bigIncrements('id');               // Primary key
                $table->string('key')->unique();          // Unique key for setting lookup
                $table->text('value')->nullable();         // Nullable setting value
                $table->string('type')->default('string'); // Type of setting (e.g., string, file, array)
                $table->string('group')->default('general'); // Group settings under categories
                $table->string('description')->nullable(); // Description to explain setting purpose
                $table->json('options')->nullable(); // To store options for dropdowns or radio buttons
                $table->timestamps();                     // Created at, updated at timestamps
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
