<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreateSuperAdminConstraint extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Trigger for DELETE
        DB::unprepared("
            CREATE TRIGGER prevent_super_admin_removal_delete
            BEFORE DELETE ON model_has_roles
            FOR EACH ROW
            BEGIN
                DECLARE superAdminRoleId INT;
                
                -- Get the Super Admin role ID
                SELECT id INTO superAdminRoleId FROM roles WHERE name = 'Super Admin' LIMIT 1;

                -- Check if the role being removed is Super Admin and user ID is 1
                IF OLD.role_id = superAdminRoleId AND OLD.model_id = 1 THEN
                    SIGNAL SQLSTATE '45000' 
                    SET MESSAGE_TEXT = 'Super Admin role cannot be removed from this user.';
                END IF;
            END;
        ");

        // Trigger for UPDATE
        DB::unprepared("
            CREATE TRIGGER prevent_super_admin_removal_update
            BEFORE UPDATE ON model_has_roles
            FOR EACH ROW
            BEGIN
                DECLARE superAdminRoleId INT;
                
                -- Get the Super Admin role ID
                SELECT id INTO superAdminRoleId FROM roles WHERE name = 'Super Admin' LIMIT 1;

                -- Check if the role being updated is Super Admin and user ID is 1
                IF OLD.role_id = superAdminRoleId AND OLD.model_id = 1 THEN
                    SIGNAL SQLSTATE '45000' 
                    SET MESSAGE_TEXT = 'Super Admin role cannot be updated for this user.';
                END IF;
            END;
        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop the triggers when rolling back
        DB::unprepared("DROP TRIGGER IF EXISTS prevent_super_admin_removal_delete");
        DB::unprepared("DROP TRIGGER IF EXISTS prevent_super_admin_removal_update");
    }
}
