<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;  // Import Schema facade
use Illuminate\Support\ServiceProvider;

use App\Models\Setting;

class MenuServiceProvider extends ServiceProvider
{
  /**
   * Register services.
   */
  public function register(): void
  {
    //
  }

  /**
   * Bootstrap services.
   */
  public function boot(): void
  {
    // Load the existing vertical and horizontal menus from JSON files
    $verticalMenuJson = file_get_contents(base_path('resources/menu/verticalMenu.json'));
    $verticalMenuData = json_decode($verticalMenuJson, true);
    
    $horizontalMenuJson = file_get_contents(base_path('resources/menu/horizontalMenu.json'));
    $horizontalMenuData = json_decode($horizontalMenuJson, true);

    // Prepare the settings submenu dynamically for vertical and horizontal menus
    $settingsSubmenu = [];

    if (Schema::hasTable('settings')) {
        // Fetch distinct settings groups from the database
        $settingsGroups = Setting::select('group')->distinct()->pluck('group');

        // Prepare the settings submenu dynamically for vertical and horizontal menus
        $settingsSubmenu[] = [
            'name' => 'New Setting',
            'url' => '/admin/settings/create/',
            'slug' => 'settings.create',
        ];

        foreach ($settingsGroups as $group) {
            $settingsSubmenu[] = [
                'name' => ucfirst($group) . ' Settings',
                'url' => '/admin/settings/group/' . $group,
                'slug' => 'settings.' . $group,
            ];
        }
    } else {
        // Optionally, add a default item if settings table doesn't exist
        $settingsSubmenu[] = [
            'name' => 'Settings Table Missing',
            'url' => '#',
            'slug' => 'settings.missing',
        ];
    }
    
    // Add the settings submenu to the vertical menu
    foreach ($verticalMenuData['menu'] as &$menuItem) {
        if (isset($menuItem['slug']) && $menuItem['slug'] === 'settings') {
            unset($menuItem['url']); // Remove the direct URL if it exists
            $menuItem['submenu'] = $settingsSubmenu;
        }
    }

    // Add the settings submenu to the horizontal menu
    foreach ($horizontalMenuData['menu'] as &$menuItem) {
        if (isset($menuItem['slug']) && $menuItem['slug'] === 'settings') {
            unset($menuItem['url']); // Remove the direct URL if it exists
            $menuItem['submenu'] = $settingsSubmenu;
        }
    }

    // Share the modified vertical and horizontal menus with all views
    View::share('menuData', [
        'vertical' => $verticalMenuData,
        'horizontal' => $horizontalMenuData
    ]);
  }
}
