<?php

namespace App\Providers;

use Illuminate\Contracts\Pagination\Paginator;
use Illuminate\Pagination\Paginator as PaginationPaginator;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Vite;
use Illuminate\Support\Facades\DB;
use App\Observers\PermissionObserver;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Seeder;
use App\Models\Setting;
use App\Models\User;

class AppServiceProvider extends ServiceProvider
{
	/**
	 * Register any application services.
	 */
	public function register(): void
	{
		//
	}

	/**
	 * Bootstrap any application services.
	 */
	public function boot(): void
	{
        // List of tables required by the application
        /*$requiredTables = [
            'failed_jobs', 'personal_access_tokens', 'permissions', 'roles', 
            'role_has_permissions', 'model_has_roles', 'users', 
            'schools', 'password_reset_tokens', 
            'media', 'logs', 'announcements', 'announcement_user', 
            'grades', 'districts', 'neighborhoods', 'students', 
            'student_contacts', 'student_siblings', 'settings', 
            'invitations', 'student_notes', 'pages',
        ];

        // Check for any missing table in a single condition
        $missingTables = array_filter($requiredTables, function($table) {
            return !Schema::hasTable($table);
        });
        
        if (app()->environment('local', 'development') && !empty($missingTables)) {
            // Run migrations and seeders
            Artisan::call('migrate');
            //Artisan::call('db:seed');

            // Check if the super_admin_constraint migration has been run
            $superAdminConstraintMigrationExists = DB::table('migrations')->where('migration', '2024_09_09_123456_create_super_admin_constraint')->exists();

            if (!$superAdminConstraintMigrationExists) {
                // Manually call the specific migration for the super_admin_constraint
                Artisan::call('migrate', ['--path' => 'database/migrations/2024_09_09_123456_create_super_admin_constraint.php']);
            }

            Artisan::call('db:seed', ['--class' => 'DistrictsSeeder']);
            Artisan::call('db:seed', ['--class' => 'NeighborhoodsSeeder']);
            Artisan::call('db:seed', ['--class' => 'SuperAdminRoleSeeder']);

            // Seed the Admin user only if it doesn't already exist
            if (!User::where('email', 'admin@uls.com')->exists()) {
                Artisan::call('db:seed', ['--class' => 'AdminSeeder']);
            }

            $requiredSettings = [
                'site_name' => 'text',
                'site_logo' => 'file',
                'site_favicon' => 'file',
                'primary_color' => 'color',
                'site_theme' => 'select',
                'users_registration' => 'boolean',
            ];
        
            foreach ($requiredSettings as $key => $type) {
                if($key == 'site_theme') {
                    Setting::firstOrCreate(
                        ['key' => $key],
                        ['value' => json_encode(['light', 'dark', 'blue']), 'type' => $type, 'group' => 'general']
                    );
                }
                else {
                    Setting::firstOrCreate(
                        ['key' => $key],
                        ['value' => null, 'type' => $type, 'group' => 'general']
                    );
                }
            }
        }*/

        if (config('app.env') !== 'local') {
            URL::forceScheme('https');
        }
        
		// Register the observer to listen to the Permission model events
		Permission::observe(PermissionObserver::class);
		
		Vite::useStyleTagAttributes(function (?string $src, string $url, ?array $chunk, ?array $manifest) {
			if ($src !== null) {
				return [
					'class' => preg_match("/(resources\/assets\/vendor\/scss\/core)-?.*/i", $src) ? 'template-customizer-core-css' :
					(preg_match("/(resources\/assets\/vendor\/scss\/theme)-?.*/i", $src) ? 'template-customizer-theme-css' : '')
				];
			}
			return [];
		});

		PaginationPaginator::useBootstrapFour();
	}
}
