<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Media extends Model
{
    use HasFactory;

    protected $fillable = [
        'file_name',
        'file_path',
        'file_type',
        'mime_type',
        'uploaded_by',
    ];

    // Accessor to get full URL of the media
    public function getUrlAttribute()
    {
        return Storage::url($this->file_path);
    }

    // Relationship with user
    public function user()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
}