<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invitation extends Model
{
    use HasFactory;

    // Add the email and name fields to allow mass assignment
    protected $fillable = [
        'email',
        'name', // Add this if the name field is optional or required
        'token',
        'status',
        'user_id',
    ];

    // Define the relationship with the User model
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // You can also specify guarded fields if you want all fields to be fillable except certain ones
    // protected $guarded = [];
}
