<?php

namespace App\Http\Middleware\App;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class SuperAdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if user is logged in and has Super Admin role
        if (!Auth::guard('superadmin')->check() || !Auth::user()->hasRole('Super Admin')) {
            return redirect('/')->with('error', 'You do not have Super Admin access.');
        }

        return $next($request);
    }
}
