<?php

namespace App\Http\Middleware\App;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use App\Events\UserOnlineStatusChanged;

class LogUserOut
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle($request, Closure $next)
    {
        if (!Auth::check() && session()->has('was_user_logged_in')) {
            $user = session()->get('was_user_logged_in');
            $user->update(['is_online' => false]);
            event(new UserOnlineStatusChanged($user)); // Broadcasting this event

            // Remove the session flag
            session()->forget('was_user_logged_in');
        }

        return $next($request);
    }
}
