<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Media;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class MediaController extends Controller
{
    // Handle media upload via AJAX
    public function upload(Request $request)
    {
        $mediaFiles = [];
    
        if ($request->hasFile('file')) {
            foreach ($request->file('file') as $file) {
                // Store the uploaded file and get the path
                $path = $file->store('media', 'public');
    
                // Save file information to database if necessary
                $media = Media::create([
                    'file_name' => $file->getClientOriginalName(),
                    'file_path' => $path,
                ]);
    
                $mediaFiles[] = [
                    'file_name' => $media->file_name,
                    'file_path' => asset('storage/' . $media->file_path),
                ];
            }
        }
    
        return response()->json(['success' => true, 'media' => $mediaFiles]);
    }

    // Edit media file (e.g., change title)
    public function edit(Request $request, Media $media)
    {
        $request->validate([
            'file_name' => 'required|string|max:255',
        ]);

        $media->update([
            'file_name' => $request->file_name,
        ]);

        return response()->json(['success' => true]);
    }

    // Delete media file
    public function destroy(Media $media)
    {
        Storage::disk('public')->delete($media->file_path);  // Remove the file from storage
        $media->delete();

        return response()->json(['success' => true]);
    }

    // Fetch all media for the media library
    public function index(Request $request)
    {
        $mediaItems = Media::latest()->paginate(10);  // Paginate the media items
        return view('dashboard.media.library', compact('mediaItems'));  // For the media library page
    }

    // Fetch media for the media library popup (AJAX)
    public function getMediaLibraryAjax()
    {
        $mediaItems = Media::latest()->paginate(10);  // For the AJAX media library
        return response()->json($mediaItems);
    }
}