<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Log;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\LogsExport;

class LogController extends Controller
{
    public function index(Request $request)
    {
        $query = Log::query()->with('user');

        // Apply search filters
        if ($request->has('search')) {
            $search = $request->input('search');
    
            $query->whereHas('user', function ($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            })->orWhere('action', 'like', '%' . $search . '%')
              ->orWhere('ip_address', 'like', '%' . $search . '%')
              ->orWhere('details', 'like', '%' . $search . '%');
        }
    
        // Paginate logs for display
        $logs = $query->latest()->paginate(20); 
    
        return view('dashboard.logs.index', compact('logs'));
    }

    public function export()
    {
        return Excel::download(new LogsExport, 'logs.xlsx');
    }

    public function clear()
    {
        // Assuming your logs are stored in a 'logs' table
        DB::table('logs')->truncate();  // This will clear all logs
    
        return redirect()->route('logs.index')->with('success', 'All logs have been cleared successfully.');
    }
}
