<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\LabTest;

class LabTestController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $labTests = LabTest::all();

        return view('dashboard.lab_tests.index', compact('labTests'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('dashboard.lab_tests.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'description' => 'required',
        ]);

        LabTest::create($request->all());

        return redirect()->route('lab_tests.index')->with('success', 'Lab Test created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(LabTest $labTest)
    {
        return view('dashboard.lab_tests.show', compact('labTest'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(LabTest $labTest)
    {
        return view('dashboard.lab_tests.edit', compact('labTest'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, LabTest $labTest)
    {
        $request->validate([
            'name' => 'required',
            'description' => 'required',
        ]);

        $labTest->update($request->all());

        return redirect()->route('lab_tests.index')->with('success', 'Lab Test updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(LabTest $labTest)
    {
        $labTest->delete();

        return redirect()->route('lab_tests.index')->with('success', 'Lab Test deleted successfully.');
    }
}