<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ClearLogs extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'logs:clear';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clear all logs from the logs table';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Assuming your logs are stored in a 'logs' table
        DB::table('logs')->truncate();  // This will clear all logs

        $this->info('All logs have been cleared successfully.');
        return Command::SUCCESS;
    }
}